<?php

use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\ForgetPasswordController;
use App\Http\Controllers\Admin\LoginController;
use App\Http\Controllers\Admin\OrderController;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\AdminController;

Route::get('/', function () {
    return view('welcome');
});
// Completed 
Route::prefix('admin')->group(function () {

    //login
    Route::get('/', [AdminController::class, 'login'])->name('admin.login');
    Route::post('/login', [LoginController::class, 'handle'])->name('login.handle');

    //forgetpassword
    Route::get('forgot_password', [AdminController::class, 'forgot_password'])->name('forgot_password');
    Route::post('/forgot_password', [ForgetPasswordController::class, 'handle'])->name('forgotpassword.handle');
    Route::get('/reset-password/{email}', [AdminController::class, 'create_password'])->name('create_password');
    Route::post('/reset-password', [ForgetPasswordController::class, 'resetPassword'])->name('reset_password_update');

    //middleware
    Route::middleware(['auth'])->group(function () {

        //dashboard
        Route::get('dashboard', [AdminController::class, 'dashboard'])->name('dashboard');
        //logout
        Route::post('logout', [LoginController::class, 'logout'])->name('logout');
        //reset_password
        Route::get('reset_password', [AdminController::class, 'reset_password'])->name('reset_password');
        Route::post('reset_password', [LoginController::class, 'handleResetPassword'])->name('reset_password_handle');
        //notification
        Route::get('notification', [AdminController::class, 'notification'])->name('notification');
        Route::post('notification_post', [DashboardController::class, 'notification_post'])->name('notification_post');
        Route::get('notifications/{id}', [DashboardController::class, 'notification_destroy'])->name('notification_delete');
        //banner
        Route::get('banner', [AdminController::class, 'banner'])->name('banner');
        Route::post('banner_post', [DashboardController::class, 'banner_post'])->name('banner_post');
        Route::get('banner_delete/{id}', [DashboardController::class, 'banner_destroy'])->name('banner_delete');
        //deliver_fee
        Route::get('delivery_fee', [AdminController::class, 'delivery_fee'])->name('delivery_fee');
        Route::post('delivery_fee_post', [DashboardController::class, 'delivery_fee_post'])->name('delivery_fee_post');
        Route::get('/delivery-fee/delete/{id}', [DashboardController::class, 'destroy'])->name('delivery_fee_delete');
        //category
        Route::get('category', [AdminController::class, 'category'])->name('category');
        Route::get('add_category', [AdminController::class, 'add_category'])->name('add_category');
        Route::post('add_category_post', [CategoryController::class, 'storeCategory'])->name('add_category_post');
        Route::get('/category-delete/{id}', [CategoryController::class, 'destroy'])->name('category_delete');
        //user_management
        Route::get('user_management', [AdminController::class, 'user_management'])->name('user_management');
        //product
        Route::get('products', [AdminController::class, 'products'])->name('products');
        Route::get('add_product', [AdminController::class, 'add_product'])->name('add_product');
        Route::post('add_product', [CategoryController::class, 'storeProduct'])->name('store_product');
        Route::get('view_product/{id}', [AdminController::class, 'view_product'])->name('view_product');
        Route::post('products/{id}', [CategoryController::class, 'update'])->name('update_product');
        Route::get('/product_delete/{id}', [CategoryController::class, 'product_delete'])->name('delete_product');
        //recent_orders
        Route::get('recent_orders', [AdminController::class, 'recent_orders'])->name('recent_orders');
        Route::post('order_accept', [OrderController::class, 'acceptOrder'])->name('accept_order');
        Route::post('order_decline', [OrderController::class, 'declineOrder'])->name('decline_order');
        //accepted_orders
        Route::get('accepted_orders', [AdminController::class, 'accepted_orders'])->name('accepted_orders');
        Route::post('ship_order', [OrderController::class, 'shipOrder'])->name('ship_order');
        //shippedorders
        Route::get('processing_orders', [AdminController::class, 'processing_orders'])->name('processing_orders');
        Route::post('confirm_delivery', [OrderController::class, 'confirmDelivery'])->name('confirm_delivery');
        //delivered_orders
        Route::get('delivered_orders', [AdminController::class, 'delivered_orders'])->name('delivered_orders');

        //profile
        Route::get('profile', [AdminController::class, 'profile'])->name('profile');
        Route::post('profile_update', [LoginController::class, 'updateProfile'])->name('profile_update');
        //view_orders
        Route::get('view_orders', [AdminController::class, 'view_orders'])->name('view_orders');
    });

});



