<?php

use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\API\CategoryController;
use App\Http\Controllers\API\ForgetPasswordController;
use App\Http\Controllers\API\LoginController;
use App\Http\Controllers\API\RegisterController;
use App\Http\Controllers\API\UserController;
use App\Http\Controllers\API\WishlistController;
use App\Http\Middleware\UserMiddleware;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

//Registration
Route::post('register_send_otp', [RegisterController::class, 'register_send_otp']);
Route::post('register_verify_otp', [RegisterController::class, 'register_verify_otp']);
//login
Route::post('login_send_otp', [LoginController::class, 'login_send_otp']);
Route::post('login_verify_otp', [LoginController::class, 'login_verify_otp']);
//forgetpassword
Route::post('send_otp', [ForgetPasswordController::class, 'send_otp']);
Route::post('verify_otp', [ForgetPasswordController::class, 'verify_otp']);
Route::post('create_password', [ForgetPasswordController::class, 'resetPassword']);


Route::middleware([UserMiddleware::class])->group(function () {
     //resetpassword
     Route::get('reset_password', [LoginController::class, 'handleResetPassword']);
     //delivery_fee
    Route::get('delivery_fee', [UserController::class, 'delivery_fee']);
    Route::get('delivery_fee_town/{town}', [CategoryController::class, 'delivery_fee_town']);
    Route::get('delivery_fee_area/{area}', [CategoryController::class, 'delivery_fee_area']);
     //banner
    Route::get('banner', [UserController::class, 'banner']);
     //notification
    Route::get('notification', [UserController::class, 'notification']);
     //category
    Route::get('category', [UserController::class, 'category']);
    Route::get('category/{id}', [UserController::class, 'category_id']);
    Route::get('category_product/{id}', [CategoryController::class, 'category_product']);
      //products
    Route::get('products', [UserController::class, 'products']);
    Route::get('products/{id}', [UserController::class, 'products_id']);
      //user_details
    Route::get('user_details', [UserController::class, 'user_details']);
      //order_details
    Route::get('order_details/{user_id}', [CategoryController::class, 'order_details']);
      //products
    Route::get('accepted_orders', [CategoryController::class, 'accepted_orders']);
    Route::get('accepted_orders/{id}', [CategoryController::class, 'acceptedorders']);
      //delivered_orders
    Route::get('delivered_orders', [CategoryController::class, 'delivered_orders']);
    Route::get('delivered_orders/{id}', [CategoryController::class, 'deliveredorders']);
      //shipped_orders
    Route::get('shipped_orders', [CategoryController::class, 'shipped_orders']);
    Route::get('shipped_orders/{id}', [CategoryController::class, 'shippedorders']);
      //wishlist
    Route::post('wishlist', [WishlistController::class, 'wishlist_create']);
    Route::get('wishlist_delete/{product_id}', [WishlistController::class, 'wishlist_delete']);
    Route::get('wishlist_display', [WishlistController::class, 'wishlist_display']);
      //order_place
    Route::post('order_place', [WishlistController::class, 'order_place']);
});















