@extends('admin.layouts')
@section('title', 'View Product')
@section('header')


    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/formILY.css">

@endsection
@section('content')


    <div class="container-fluid page-wrapper">

        <div class="row">
            <div class="d-flex align-items-center">
                <h3 class="page-top-heading">View Product</h3>
            </div>
        </div>

        <div class="row d-flex justify-content-center mt-4">
            <div class="col-lg-12">
                <div class="card ILY-form-card">
                    <div class="card-header d-none">
                        <h5 class="card-title">View Product</h5>
                    </div>
                    <div class="card-body">

                


                        {{-- fresh --}}
                        <form action="{{ route('update_product', $product->id) }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            @method('POST') <!-- Correct method for update -->
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="d-flex justify-content-center">
                                        <div class="product-upload">
                                            <div class="product-edit">
                                                <input type='file' id="imageUpload" name="image" accept=".png, .jpg, .jpeg" />
                                                <label for="imageUpload"></label>
                                            </div>
                                            <div class="product-preview">
                                                <div id="imagePreview" style="background-image: url('{{ asset($product->image) }}');">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                        
                                <!-- Category Select -->
                                <div class="col-lg-6">
                                    <div class="form-group mb-3">
                                        <label for="category_select" class="form-label">Select Category</label>
                                        <select class="form-select" name="category_id" aria-label="Category Select">
                                            <option value="" disabled>Select</option>
                                            @foreach($categories as $category)
                                                <option value="{{ $category->id }}" {{ $product->category_id == $category->id ? 'selected' : '' }}>{{ $category->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('category_id')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                        
                                <!-- Subcategory Select -->
                                <div class="col-lg-6">
                                    <div class="form-group mb-3">
                                        <label for="subcategory_select" class="form-label">Select Sub Category</label>
                                        <select class="form-select" name="subcategory_name" aria-label="Subcategory Select">
                                            <option value="" disabled>Select</option>
                                            <option value="SubCategory1" {{ $product->subcategory_name == 'SubCategory1' ? 'selected' : '' }}>SubCategory1</option>
                                            <option value="SubCategory2" {{ $product->subcategory_name == 'SubCategory2' ? 'selected' : '' }}>SubCategory2</option>
                                        </select>
                                        @error('subcategory_name')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                        
                                <!-- Brand -->
                                <div class="col-lg-6">
                                    <div class="form-group mb-3">
                                        <label for="brand_name" class="form-label">Brand</label>
                                        <input type="text" name="brand" class="form-control" id="brand_name" placeholder="Enter Brand Name" value="{{ old('brand', $product->brand) }}">
                                        @error('brand')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                        
                                <!-- Title -->
                                <div class="col-lg-6">
                                    <div class="form-group mb-3">
                                        <label for="product_title" class="form-label">Title</label>
                                        <input type="text" name="title" class="form-control" id="product_title" placeholder="Enter Product Title" value="{{ old('title', $product->title) }}">
                                        @error('title')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                        
                                <!-- Description -->
                                <div class="col-lg-6">
                                    <div class="form-group mb-3">
                                        <label for="description" class="form-label">Description</label>
                                        <textarea name="description" class="form-control" id="description" rows="3" placeholder="Write Here">{{ old('description', $product->description) }}</textarea>
                                        @error('description')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                        
                                <!-- Package -->
                                <div class="col-lg-6">
                                    <div class="form-group mb-3">
                                        <label for="package" class="form-label">Package</label>
                                        <input type="text" name="package" class="form-control" id="package" placeholder="Enter Package" value="{{ old('package', $product->package) }}">
                                        @error('package')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                        
                                <!-- Variant Container -->
                                <div class="variant-row-container mt-3">
                                    <div class="row variant-row" id="variant-row">
                                        <div class="col-lg-12">
                                            <p class="variant-heading"><i class="fa-solid fa-arrow-down me-1"></i>Variant <span class="ps-1 variant-count" id="variant-count">1</span></p>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group mb-3">
                                                <label for="unit" class="form-label">Unit</label>
                                                <input type="text" name="unit[]"  class="form-control" id="unit" placeholder="Enter Product Unit" value="{{ old('unit', $product->unit) }}">
                                                @error('unit')
                                                    <small class="text-danger">{{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group mb-3">
                                                <label for="discount" class="form-label">Discount</label>
                                                <input type="text" name="discount[]"  class="form-control" id="discount" placeholder="%" value="{{ old('discount', $product->discount) }}">
                                                @error('discount')
                                                    <small class="text-danger">{{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group mb-3">
                                                <label for="mrp" class="form-label">MRP</label>
                                                <input type="text" name="mrp[]" class="form-control" id="mrp" placeholder="₹0.00" value="{{ old('mrp', $product->mrp) }}">
                                                @error('mrp')
                                                    <small class="text-danger">{{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group mb-3">
                                                <label for="price" class="form-label">Price</label>
                                                <input type="text"  name="price[]" class="form-control" id="price" placeholder="₹0.00" value="{{ old('price', $product->price) }}">
                                                @error('price')
                                                    <small class="text-danger">{{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                </div>
                        
                                <!-- Add Variant Button -->
                                <div class="row mt-2">
                                    <div class="col-lg-12">
                                        <button type="button" class="btn add_variant-btn" id="add-variant-btn"><i class="fa-solid fa-plus me-2"></i>Add Variant</button>
                                    </div>
                                </div>
                        
                                <!-- Specification Row Starts -->
                                <div class="row mt-5">
                                    <div class="col-lg-12">
                                        <p class="specification-heading">Specification</p>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="specification-container" id="specification-container">
                                            <div class="row specification-row" id="specification-row">
                                                <div class="col-lg-5 col-5">
                                                    <div class="form-group mb-3">
                                                        <label for="spec_title" class="form-label">Title</label>
                                                        <input type="text" name="spec_title[]" class="form-control" id="spec_title" placeholder="Enter Specification Title" value="{{ old('spec_title', $product->spec_title) }}">
                                                        @error('spec_title.*')
                                                            <small class="text-danger">{{ $message }}</small>
                                                        @enderror
                                                    </div>
                                                </div>
                                                <div class="col-lg-6 col-6">
                                                    <div class="form-group mb-3">
                                                        <label for="spec_description" class="form-label">Description</label>
                                                        <textarea name="spec_description[]" class="form-control" id="spec_description" rows="2" placeholder="Enter Description">{{ old('spec_description', $product->spec_description) }}</textarea>
                                                        @error('spec_description.*')
                                                            <small class="text-danger">{{ $message }}</small>
                                                        @enderror
                                                    </div>
                                                </div>
                                                <div class="col-lg-1 col-1 mb-3 d-flex align-items-center">
                                                    <button type="button" class="btn btn-success rounded-pill add-spec"><i class="fa-solid fa-plus"></i></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                        
                                <div class="button-container mt-5">
                                    <button type="submit" class="btn btn-primary submit-btn w-100 py-3" id="update-btn"><i class="fa-solid fa-rotate me-2" id="update-icon"></i>Update</button>
                                </div>
                            </div>
                        </form>
                        
                        {{-- <form action="{{ route('update_product', $product->id) }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            @method('POST')
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="d-flex justify-content-center">
                                        <div class="product-upload">
                                            <div class="product-edit">
                                                <input type='file' id="imageUpload" name="image" accept=".png, .jpg, .jpeg" />
                                                <label for="imageUpload"></label>
                                            </div>
                                            <div class="product-preview">
                                                <div id="imagePreview" style="background-image: url('{{ asset($product->image) }}');">
                                                   
                                                </div>
                                            </div>
                                        </div>
                                        
                                    </div>
                                </div>
    
                                <!-- Category Select -->
                                <div class="col-lg-6">
                                   <div class="form-group mb-3">
                                        <label for="category_select" class="form-label">Select Category</label>
                                        <select class="form-select" name="category_id" aria-label="Category Select">
                                            <option value="" disabled>Select</option>
                                            @foreach($categories as $category)
                                                <option value="{{ $category->id }}" {{ $product->category_id == $category->id ? 'selected' : '' }}>{{ $category->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('category_id')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
    
                                <!-- Subcategory Select -->
                                <div class="col-lg-6">
                                   <div class="form-group mb-3">
                                        <label for="subcategory_select" class="form-label">Select Sub Category</label>
                                        <select class="form-select" name="subcategory_name" aria-label="Subcategory Select">
                                            <option value="" disabled>Select</option>
                                            <option value="SubCategory1" {{ $product->subcategory_name == 'SubCategory1' ? 'selected' : '' }}>SubCategory1</option>
                                            <option value="SubCategory2" {{ $product->subcategory_name == 'SubCategory2' ? 'selected' : '' }}>SubCategory2</option>
                                        </select>
                                        @error('subcategory_name')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
    
                                <!-- Brand -->
                                <div class="col-lg-6">
                                    <div class="form-group mb-3">
                                        <label for="brand_name" class="form-label">Brand</label>
                                        <input type="text" name="brand" class="form-control" id="brand_name" placeholder="Enter Brand Name" value="{{ old('brand', $product->brand) }}">
                                        @error('brand')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
    
                                <!-- Title -->
                                <div class="col-lg-6">
                                    <div class="form-group mb-3">
                                        <label for="product_title" class="form-label">Title</label>
                                        <input type="text" name="title" class="form-control" id="product_title" placeholder="Enter Product Title" value="{{ old('title', $product->title) }}">
                                        @error('title')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
    
                                <!-- Description -->
                                <div class="col-lg-6">
                                    <div class="form-group mb-3">
                                        <label for="description" class="form-label">Description</label>
                                        <textarea name="description" class="form-control" id="description" rows="3" placeholder="Write Here">{{ old('description', $product->description) }}</textarea>
                                        @error('description')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
    
                                <!-- Package -->
                                <div class="col-lg-6">
                                    <div class="form-group mb-3">
                                        <label for="package" class="form-label">Package</label>
                                        <input type="text" name="package" class="form-control" id="package" placeholder="Enter Package" value="{{ old('package', $product->package) }}">
                                        @error('package')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
    
                                <!-- Variant Container -->
                                <div class="variant-row-container mt-3">
                                     <!-- Variant Row Starts -->
                                    <div class="row variant-row" id="variant-row">
                                        <div class="col-lg-12">
                                            <p class="variant-heading"><i class="fa-solid fa-arrow-down me-1"></i>Variant <span class="ps-1 variant-count" id="variant-count">1</span></p>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group mb-3">
                                                <label for="unit" class="form-label">Unit</label>
                                                <input type="text" name="unit" class="form-control" id="unit" placeholder="Enter Product Unit" value="{{ old('unit', $product->unit) }}">
                                                @error('unit')
                                                    <small class="text-danger">{{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group mb-3">
                                                <label for="discount" class="form-label">Discount</label>
                                                <input type="text" name="discount" class="form-control" id="discount" placeholder="%" value="{{ old('discount', $product->discount) }}">
                                                @error('discount')
                                                    <small class="text-danger">{{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group mb-3">
                                                <label for="mrp" class="form-label">MRP</label>
                                                <input type="text" name="mrp" class="form-control" id="mrp" placeholder="₹0.00" value="{{ old('mrp', $product->mrp) }}">
                                                @error('mrp')
                                                    <small class="text-danger">{{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group mb-3">
                                                <label for="price" class="form-label">Price</label>
                                                <input type="text" name="price" class="form-control" id="price" placeholder="₹0.00" value="{{ old('price', $product->price) }}">
                                                @error('price')
                                                    <small class="text-danger">{{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Variant Row Ends.. -->
                                </div>
                                <!-- Variant Container Ends.. -->
    
                                <!-- Add Variant Button -->
                                 <div class="row mt-2">
                                    <div class="col-lg-12">
                                      <button type="button" class="btn add_variant-btn" id="add-variant-btn"><i class="fa-solid fa-plus me-2"></i>Add Variant</button>
                                    </div>
                                </div>
                                <!-- Add Variant Button -->
    
                                <!-- Specification Row Starts -->
                                <div class="row mt-5">
                                   <div class="col-lg-12">
                                        <p class="specification-heading">Specification</p>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="specification-container" id="specification-container">
                                            <div class="row specification-row" id="specification-row">
                                                <div class="col-lg-5 col-5">
                                                    <div class="form-group mb-3">
                                                        <label for="spec_title" class="form-label">Title</label>
                                                        <input type="text" name="title" class="form-control" id="spec_title" placeholder="Enter Specification Title" value="{{ old('title', $product->title) }}">
                                                        @error('spec_title')
                                                            <small class="text-danger">{{ $message }}</small>
                                                        @enderror
                                                    </div>
                                                </div>
                                                <div class="col-lg-6 col-6">
                                                    <div class="form-group mb-3">
                                                        <label for="spec_description" class="form-label">Description</label>
                                                        <textarea name="description" class="form-control" id="spec_description" rows="2" placeholder="Enter Description" value="{{ old('description', $product->description) }}"></textarea>
                                                        @error('spec_description')
                                                            <small class="text-danger">{{ $message }}</small>
                                                        @enderror
                                                    </div>
                                                </div>
                                                <div class="col-lg-1 col-1 mb-3 d-flex align-items-center">
                                                    <button type="button" class="btn btn-success rounded-pill add-spec"><i class="fa-solid fa-plus"></i></button>
                                                </div>
                                            </div>
                                            <!-- Specification Row Ends.. -->
                                        </div>
                                        <!-- Specification Container Ends.... -->
                                    </div>
                                </div>
                                <!-- Specification Row Ends -->
    
                                <div class="button-container mt-5">
                                    <button type="submit" class="btn btn-primary submit-btn w-100 py-3" id="update-btn"><i class="fa-solid fa-rotate me-2" id="update-icon"></i>Update</button>
                                </div>
                            </div>
                            <!-- Card row ends.. -->
                        </form> --}}
                        <!-- form ends... -->
                    </div>
                </div>
            </div>
        </div>
        <!-- Row Ends.. -->


    </div>
    <!-- end container fluid -->



    <!-- jQuery CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- JS for Product Edit and View -->
    <script>
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#imagePreview').css('background-image', 'url(' + e.target.result + ')');
                    $('#imagePreview').hide();
                    $('#imagePreview').fadeIn(650);
                }
                reader.readAsDataURL(input.files[0]);
            }
        }
        $("#imageUpload").change(function() {
            readURL(this);
        });
    </script>
    <!-- JS for Product Edit and View Ends..-->


    <!-- JS for Adding Varient -->
    <script>
        $(document).ready(function() {
            let variantCount = 1;
            $('#add-variant-btn').click(function() {
                variantCount++;
                let newVariantRow = $('#variant-row').clone();
                newVariantRow.attr('id', 'variant-row-' + variantCount); // Ensure unique IDs if needed
                newVariantRow.find('.variant-count').text(variantCount);
                newVariantRow.find('input').val(''); // Reset input values
                $('.variant-row-container').append(newVariantRow);
            });
        });
    </script>
    <!-- JS for Adding Varient Ends...-->

    <!-- JS For Adding Specification -->
    <script>
        $(document).ready(function() {
            $(document).on('click', '.btn-success', function() {
                let newRow = $('#specification-row').last().clone();
                newRow.find('input[type="text"], textarea').val('');
                newRow.find('.btn-success')
                    .removeClass('btn-success')
                    .addClass('btn-danger')
                    .html('<i class="fa-solid fa-trash"></i>');
                $('#specification-container').append(newRow);
            });
            $(document).on('click', '.btn-danger', function() {
                $(this).closest('.specification-row').remove();
            });
        });
    </script>
    <!-- JS For Adding Specification -->


@endsection
@section('footer')



@endsection
