@extends('admin.layouts')
@section('title', 'Reset Password')
@section('header')

<!-- Page CSS -->
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/formILY.css">
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/authentication.css">

@endsection
@section('content')




<div class="container-fluid reset-pwd-container">
    <div class="row">
        <div class="">
              <h3 class="page-top-heading">Reset Password</h3> 
        </div>
    </div>

       <div class="row d-flex justify-content-center mt-4">
            <div class="col-lg-7">
                <div class="card ILY-form-card">
                    <div class="card-header">
                        <p class="form-slogan" style="margin-bottom:10px !important;">Enter old password to reset your password. </p>
                    </div>
                    <div class="card-body pt-0">

                         <!-- Form start -->
                         <form action="{{ route('reset_password_handle') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-lg-12">
                               <div class="input-group mb-4 position-relative">
                                    <span class="input-group-text">
                                        <img src="{{asset('/assets')}}/images/icons/lock.svg" alt="Lock Icon">
                                    </span>
                                    <input type="password" name="password" id="password" class="form-control" placeholder="Old Password" aria-label="Old Password" aria-describedby="OldPassword" autocomplete="off" required>
                                    <button type="button" id="toggler" class="btn transparent-btn"><i id="icon" class="fa-solid fa-eye-slash"></i></button>
                                </div>
                            </div>
                            <div class="col-lg-12">
                               <div class="input-group mb-4 position-relative">
                                    <span class="input-group-text">
                                        <img src="{{asset('/assets')}}/images/icons/lock.svg" alt="Lock Icon">
                                    </span>
                                    <input type="password" name="new_pwd" id="new_pwd" class="form-control" placeholder="New Password" aria-label="New Password" aria-describedby="NewPassword" autocomplete="off" required>
                                    <button type="button" id="toggler3" class="btn transparent-btn"><i id="icon3" class="fa-solid fa-eye-slash"></i></button>
                                </div>
                            </div>
                            <div class="col-lg-12">
                               <div class="input-group mb-4 position-relative">
                                    <span class="input-group-text">
                                        <img src="{{asset('/assets')}}/images/icons/lock.svg" alt="Lock Icon">
                                    </span>
                                    <input type="password" name="new_pwd_confirmation" id="confirm_pwd" class="form-control" placeholder="Confirm Password" aria-label="Confirm Password" aria-describedby="ConfirmPassword" autocomplete="off" required>
                                    <button type="button" id="toggler2" class="btn transparent-btn"><i id="icon2" class="fa-solid fa-eye-slash"></i></button>
                                </div>
                                <small class="text-danger" id="pwd-condition">Password must have 8 character and include a special character (~`! @#$%^&*-_+={}[]|\;:"<>,./?)</small>
                            </div>
                            <div class="col-lg-12">
                                <button type="submit" class="btn btn-primary full-width-btn mt-3 mb-2"><i class="fa-regular fa-circle-check me-2"></i>Submit</button>
                            </div>
                        </div>
                        <!-- Form Row Ends -->
                    </form>
                    <!-- Form Ends -->
                </div>
            </div>
            <!-- Card Ends -->
        </div>
    </div>

</div>
<!-- Container Fluid -->



{{-- <!-- Validation JS -->

    
    @endsection
    
    @section('footer')
    <!-- Page JS -->
    {{-- <script type="text/javascript" src="{{ asset('/assets/js/formFM.js') }}"></script>
    <script type="text/javascript" src="{{ asset('/assets/js/authentication.js') }}"></script> --}}
    @endsection