<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Forgot Password | ILYBAZAR</title>
    <link rel="icon" href="{{ asset('/assets') }}/images/favicon.ico" type="image/x-icon">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/bootstrap/5.3.2/bootstrap.min.css">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="{{ asset('/assets') }}/css/icons/fontawesome/css/fontawesome.css">
    <link rel="stylesheet" href="{{ asset('/assets') }}/css/icons/fontawesome/css/brands.css">
    <link rel="stylesheet" href="{{ asset('/assets') }}/css/icons/fontawesome/css/regular.css">
    <link rel="stylesheet" href="{{ asset('/assets') }}/css/icons/fontawesome/css/solid.css">

    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/style.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/authentication.css">

    <style>
        .logo-widget {
            background: #D4EFFF;
            background-size: cover !important;
        }

        #otp-actions {
            display: none;
            opacity: 0;
            position: relative;
            bottom: -20px;
            transition: opacity 0.5s ease-in-out, bottom 0.5s ease-in-out;
        }

        #otp-actions.show {
            opacity: 1;
            bottom: 0;
        }
    </style>

</head>

<body>
    <div class="page-content overflow-hidden min-vh-100 forgot-pwd-container">
        <div class="row g-0 vh-100">
            <div class="col-xl-5 col-lg-5 col-md-6 col-sm-6 rightside-widget-col">
                <div class="p-lg-5 p-4 h-100 logo-widget">
                    <div class="d-flex justify-content-center align-items-center h-100">
                        <div class="">
                            <img src="{{ asset('/assets') }}/images/login-frame.svg" style="height:400px;"
                                class="inframe-logo" alt="logo frame">
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-7 col-lg-7 col-md-6 col-sm-6 d-flex justify-content-center align-items-center">
                <div class="py-3 px-lg-5 px-md-4 px-sm-4 px-4 form-container row">
                    <div class="d-flex justify-content-center mb-1">
                        <img src="{{ asset('/assets') }}/images/logo-horizontal.svg" class="my-3 d-none widget-logo"
                            alt="logo-horizontal">
                    </div>
                    <div class="text-start">
                        <h3 class="form-heading">Email Verification</h3>
                        <p class="py-2 form-slogan">Enter your email address and we will send a link to reset your
                            password.</p>
                    </div>

                    <!-- Form starts -->

                    <form id="forgot_pswrdpage" action="{{ route('forgotpassword.handle') }}" method="POST"
                        autocomplete="off">
                        @csrf
                        <div class="input-group mb-4">
                            <span class="input-group-text">
                                <img src="{{ asset('/assets') }}/images/icons/envelope.svg" alt="Email Icon">
                            </span>
                            {{-- <input type="email" name="email" class="form-control" placeholder="E-mail"
                                aria-label="Email" aria-describedby="Email" required> --}}
                                <input type="email" id="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" placeholder="Email" required>
                        
                                @error('email')
                                    <div class="alert alert-danger mt-1 mb-1">{{ $message }}</div>
                                @enderror   
                        </div>
                        <div class="mt-2">
                            <div class="otp-container" id="otpContainer">
                                <button class="btn btn-warning send-otp-btn" type="submit" name="action"
                                    value="send_otp">Send OTP</button>
                                {{-- <button type="button" class="btn btn-warning send-otp-btn" id="send-otp-btn">Send OTP</button> --}}
                                {{-- <input type="text" name="send_otp" class="form-control send_otp" id="send_otp"
                                    placeholder="OTP"> --}}
                                 <input type="text" id="send_otp" class="form-control send_otp  @error('otp') is-invalid @enderror" name="send_otp" placeholder="Enter OTP" >
                      
                      
                                    @error('otp')
                                        <div class="alert alert-danger mt-1 mb-1">{{ $message }}</div>
                                    @enderror  
                            </div>
                        </div>
                        <div class="login-btn-container">
                            {{-- <button type="submit" class="btn btn-primary auth-submit-btn w-100"> --}}
                            <button class="btn btn-primary auth-submit-btn w-100" type="submit" name="action"
                                value="verify_otp">Submit</button>

                            </button>
                        </div>
                        <div class="otp-actions text-center" id="otp-actions" style="display:none;">
                            <p class="resend-otp-timer">Resend OTP in <span>05:00</span></p>
                        </div>
                    </form>
                    <!-- Form Ends -->
                </div>
            </div>
        </div>
    </div>


    <script>

        $(document).ready(function() {
            $('#forgot_pswrdpage').on('submit', function(e) {
                e.preventDefault();  
        
                var actionType = $('button[type="submit"][clicked=true]').val();
        var formData = $(this).serialize();  

        
                $.ajax({
                    url: "{{ route('forgotpassword.handle') }}",
                    method: 'POST',
                    data: formData,
                    success: function(response) {
                        // Clear previous messages
                        $('#alert-placeholder').html('');
        
                        // Show success message
                        if (response.success) {
                            $('#alert-placeholder').html('<div class="alert alert-success">' + response.success + '</div>');
                        } else {
                            $('#alert-placeholder').html('<div class="alert alert-success">Password reset instructions have been sent to your email.</div>');
                        }
        
                        // Reset form only on success
                        $('#otp').val(''); // Clear OTP input field
                    },
                    error: function(xhr) {
                        // Clear previous messages
                        $('#alert-placeholder').html('');
        
                        if (xhr.status === 422) {
                            var errors = xhr.responseJSON.errors;
                            var errorHtml = '<div class="alert alert-danger"><ul>';
                            $.each(errors, function(key, value) {
                                errorHtml += '<li>' + value[0] + '</li>';
                            });
                            errorHtml += '</ul></div>';
                            $('#alert-placeholder').html(errorHtml);
                        } else {
                            $('#alert-placeholder').html('<div class="alert alert-danger">An error occurred. Please try again.</div>');
                        }
                    }
                });
            });
        });
        
        
        </script>
        {{-- toast --}}
    <!-- Success Toast -->
    @if (session('successmessage'))
    <div id="success-toast" class="toast bg-success align-items-center border-0 show" role="alert"
        aria-live="assertive" aria-atomic="true"
        style="position: fixed; top: 150px; right: 20px; z-index: 1050; border-radius: 8px;">
        <div class="toast-body d-flex text-white align-items-center">
            <i class="fa-regular fa-circle-check" style="font-size: 20px; margin-right: 10px;"></i>
            <div>
                {{ session('successmessage') }}
            </div>
            <button type="button" class="btn-close btn-close-white ms-2" data-bs-dismiss="toast"
                aria-label="Close"></button>
        </div>
    </div>
@endif

<!-- Error Toast -->
@if ($errors->any())
    <div id="error-toast" class="toast bg-danger align-items-center border-0 show" role="alert"
        aria-live="assertive" aria-atomic="true"
        style="position: fixed; top: 80px; right: 20px; z-index: 1050; border-radius: 8px;">
        <div class="toast-body d-flex text-white align-items-center">
            <i class="fa-solid fa-circle-exclamation" style="font-size: 20px; margin-right: 10px;"></i>
            <div>
                @foreach ($errors->all() as $error)
                    <div>{{ $error }}</div>
                @endforeach
            </div>
            <button type="button" class="btn-close btn-close-white ms-2" data-bs-dismiss="toast"
                aria-label="Close"></button>
        </div>
    </div>
@endif

  

<!-- ====================================================================================================== -->
    <!-- Page JS -->
    <script type="text/javascript" src="{{asset('/assets')}}/js/authentication.js"></script>
    <script type="text/javascript" src="{{asset('/assets')}}/js/bootstrap/5.3.2/bootstrap.min.js"></script>

    <script>
        const otpInput = document.getElementById('send_otp');
        const otpContainer = document.getElementById('otpContainer');
        otpInput.addEventListener('focus', function() {
            otpContainer.style.borderColor = '#022859';
        });
        otpInput.addEventListener('blur', function() {
            otpContainer.style.borderColor = 'rgba(179, 180, 186, 1)';
        });
    </script>

<!-- ====================================================================================================== -->   



<!-- JS for Resend OTP Timer -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        var sendOtpButton = document.getElementById('send-otp-btn');
        var otpActions = document.getElementById('otp-actions');
        var timerDisplay = document.querySelector('.resend-otp-timer span');
        var initialTime = 5 * 60; 

        sendOtpButton.addEventListener('click', function() {
            sendOtpButton.classList.add('disabled');
            otpActions.style.display = 'block';
            setTimeout(function() {
                otpActions.classList.add('show');
            }, 10); 
            startCountdown(initialTime);
        });

        function startCountdown(duration) {
            var timer = duration;
            var interval = setInterval(function() {
                var minutes = Math.floor(timer / 60);
                var seconds = timer % 60;
                minutes = minutes < 10 ? '0' + minutes : minutes;
                seconds = seconds < 10 ? '0' + seconds : seconds;
                timerDisplay.textContent = minutes + ':' + seconds;

                if (--timer < 0) {
                    clearInterval(interval);
                    sendOtpButton.classList.remove('disabled');
                    otpActions.classList.remove('show');
                    setTimeout(function() {
                        otpActions.style.display = 'none';
                    }, 500); 
                }
            }, 1000);
        }
    });
</script>






<script type="text/javascript" src="{{ asset('/assets') }}/js/authentication.js"></script>
<script type="text/javascript" src="{{ asset('/assets') }}/js/bootstrap/5.3.2/bootstrap.min.js"></script>




</body>

</html>



