@extends('admin.layouts')
@section('title', 'Category')
@section('header')

<!-- DataTable CSS -->
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/datatable/dataTables.bootstrap5.min.css">
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/datatable/responsive.bootstrap.min.css">
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/datatable/buttons.dataTables.min.css">

<!-- Page CSS -->
<link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/formILY.css">

@endsection
@section('content')


<div class="container-fluid page-wrapper category-container">
    <div class="row">
        <div class="d-flex justify-content-between align-items-center">
            <h3 class="page-top-heading">Category</h3>
            <a type="button" href="{{ route('add_category') }}" class="btn btn-primary feature-btn"><i class="fa-solid fa-circle-plus me-2"></i>Add Category</a>
        </div>
    </div>

    <!-- Table Row -->
    <div class="row mt-4">
        <div class="col-lg-12">
            <div class="card datatable-card">
                <div class="card-body">
                    <table id="data-table" class="table nowrap align-middle" style="width:100%">
                        <thead>
                            <tr>
                                <th>SN</th>
                                <th>TOWN</th>
                                <th>IMAGE PREVIEW</th>
                                <th>NAME</th>
                                <th>TYPE</th>
                                <th>ACTION</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($categories as $category)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $category->deliveryFeeMaster ? $category->deliveryFeeMaster->town : 'N/A' }}</td> <!-- Display the town name -->
                                <td>
                                    @if($category->image)
                                        <img src="{{ asset($category->image) }}" class="preview-td-img" alt="preview image" style="width: 100px; height: auto;">
                                    @else
                                        No Image
                                    @endif
                                </td>
                                <td>{{ $category->name }}</td>
                                <td>{{ $category->type == 1 ? 'Category' : 'SubCategory' }}</td>
                                {{-- <td>
                                    <button type="button" data-bs-toggle="modal" data-bs-target="#DeleteModal" class="btn transparent-btn text-danger text-decoration-underline">Delete</button>
                                </td> --}}
                                <td>
                                    <!-- Delete Button triggers the modal -->
                                    <button type="button" data-bs-toggle="modal" data-bs-target="#DeleteModal-{{ $category->id }}" class="btn transparent-btn text-danger text-decoration-underline">Delete</button>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <!-- Table Row Ends -->
</div>
@foreach($categories as $category)
<div class="modal fade zoom-in" id="DeleteModal-{{ $category->id }}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-body">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="p-3">
                            <div class="text-center">
                                <img class="mb-3" src="{{asset('/assets')}}/images/icons/delete-icon.svg">
                                <p class="my-4 are-you-sure">Are You Sure?</p>
                                <p class="text-muted my-2 are-you-sure-subtext">Are you sure you want to delete this {{ $category->name }}?</p>
                            </div>
                            <div class="d-flex align-items-center mt-5 mb-3">
                                <button data-bs-dismiss="modal" class="btn btn-light cancel-btn me-3">Cancel</button>
                                <a href="{{ route('category_delete', $category->id) }}" class="btn btn-primary yes-btn">
                                    <i class="fa-regular fa-circle-check me-2"></i>Yes, Delete It!
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endforeach

@endsection
@section('footer')


<!-- JQuery CDN -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

<!-- Datatable JS -->
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/dataTables.bootstrap5.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/datatables.init.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/dataTables.responsive.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/buttons.html5.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/buttons.print.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/jszip.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/pdfmake.min.js"></script>
<script type="text/javascript" src="{{asset('/assets')}}/js/datatable/vfs_fonts.js"></script>



@endsection


