@extends('admin.layouts')
@section('title', 'Add Category')
@section('header')


    <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('/assets') }}/css/formILY.css">

@endsection
@section('content')



    <div class="container-fluid page-wrapper category-container">

        <div class="row">
            <div class="d-flex align-items-center">
                <h3 class="page-top-heading">Add Category</h3>
            </div>
        </div>

        <div class="row d-flex justify-content-center mt-4">
            <div class="col-lg-6">
                <div class="card ILY-form-card">
                    <div class="card-header d-none">
                        <h5 class="card-title">Add Category</h5>
                    </div>
                    <div class="card-body">
                        {{-- form_start --}}
                        <form action="{{ route('add_category_post') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="form-group mb-3">
                                        <label for="town_id" class="form-label">Select Town</label>
                                        <select class="form-select" name="town_id" id="town_id" aria-label="Town Select">
                                            <option value="">Select</option>
                                            @foreach ($towns as $town)
                                                <option value="{{ $town->id }}">{{ $town->town }}</option>
                                            @endforeach
                                        </select>
                                        @error('town_id')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                   
                                    <div class="form-group mb-3">
                                        <label for="category_img" class="form-label">Choose Image</label>
                                        <input class="form-control" name="category_img" type="file" id="category_img" accept="image/*">
                                        @error('category_img')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                        
                                    <div class="form-group mb-3">
                                        <label for="category_name" class="form-label">Name</label>
                                        <input type="text" name="category_name" class="form-control" id="category_name" placeholder="Enter Name" value="{{ old('category_name') }}">
                                        @error('category_name')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                        
                                    <div class="form-group mb-3">
                                        <label for="category_type" class="form-label">Select Category Type</label>
                                        <select class="form-select" name="category_type" id="category_type" aria-label="Category Type Select">
                                            <option value="">Select</option>
                                            <option value="1" {{ old('category_type') == '1' ? 'selected' : '' }}>Category</option>
                                            <option value="2" {{ old('category_type') == '2' ? 'selected' : '' }}>SubCategory</option>
                                        </select>
                                        @error('category_type')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                        
                                    <div class="form-group mb-3">
                                        <label for="link_to" class="form-label">If Type Sub Category Then Link To</label>
                                        <input type="text" name="link_to" class="form-control" id="link_to" placeholder="Link To" value="{{ old('link_to') }}">
                                        @error('link_to')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                        
                                    <div class="button-container mt-4">
                                        <button type="submit" class="btn btn-primary submit-btn">
                                            <i class="fa-regular fa-circle-check me-2"></i>Submit
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                        
                        {{-- form_end --}}
                    </div>
                </div>
            </div>
        </div>
        <!-- Row Ends.. -->


    </div>
    <!-- end container fluid -->
@endsection
@section('footer')
@endsection
