<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('order_details', function (Blueprint $table) {
            $table->id();
            $table->string('user_id');
            $table->string('user_name');
            $table->string('category_id')->nullable();
            $table->timestamp('order_date')->nullable();
            $table->string('category_name')->nullable();
            $table->string('product_details_id');
            $table->string('product_details_name');
            $table->text('delivery_address');
            $table->text('instruction')->nullable();
            $table->string('status')->default('pending');
            $table->integer('quantity');
            $table->decimal('amount', 10, 2);
            $table->string('courier')->nullable();
            $table->string('tracking_id')->nullable();
            $table->string('one')->nullable();
            $table->string('two')->nullable();
            $table->string('three')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('order_details');
    }
};
