<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('categories', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('town_id')->unsigned()->nullable();
            $table->foreign('town_id')
              ->references('id')->on('delivery_fee_masters')
              ->onDelete('cascade');
            $table->string('town_name')->nullable();
            $table->string('image')->nullable();
            $table->string('name');
            $table->string('type');
            $table->string('subcategory')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('categories');
    }
};
