<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;
    protected $fillable = [
        'category_id',
        'category_name',
        'subcategory_name',
         'image',
        'brand',
        'package',
        'title',
        'description',

        
       ];
       public function category()
       {
           return $this->belongsTo(Category::class, 'category_id');
       }
      
       public function variants()
    {
        return $this->hasMany(ProductVarient::class, 'product_id');
    }
  
}
