<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    use HasFactory;
    protected $fillable=[
        'town_id',
        'town_name',
        'image',
        'name',
        'type',
        'subcategory',
    ];

    public function deliveryFeeMaster()
    {
        return $this->belongsTo(DeliveryFeeMaster::class, 'town_id');


    }

    public function products()
    {
        return $this->hasMany(Product::class);
    }
}