<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'               => $this->id,
            'category_id'      => $this->category_id,
            'category_name'    => $this->category_name,
            'subcategory_name' => $this->subcategory_name,
            'title'            => $this->title,
            'description'      => $this->description,
            'unit'             => $this->unit,
            'price'            => $this->price,
            'image'            => $this->image,
            'brand'            => $this->brand,
            'package'          => $this->package,
            'mrp'              => $this->mrp,
            'discount'         => $this->discount,
        ];
    }
}
