<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;


class OrderplacedResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'order_id'             => $this->id,
            'user_id'              => $this->user_id,
            'user_name'            => $this->user_name,
            'category_id'          => $this->category_id,
            'category_name'        => $this->category_name,
            'product_details_id'   => array_map('trim', explode('~', $this->product_details_id)),
            'product_details_name' => array_map('trim', explode('~', $this->product_details_name)),
            'quantity'             => array_map('trim', explode('~', $this->quantity)),
            'amount'               => array_map('trim', explode('~', $this->amount)),
            'delivery_address'     => rtrim($this->delivery_address, '~'),
            'instruction'          => rtrim($this->instruction, '~'),
            'created_at'           => $this->created_at->toDateTimeString(),
            'updated_at'           => $this->updated_at->toDateTimeString(),
        ];
    }
}
