<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderDetailsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray($request)
    {
        return [
            'order_date'           => $this->order_date,
            'user_id'              => $this->user_id,
            'user_name'            => $this->user_name,
            'category_id'          => $this->category_id,
            'category_name'        => $this->category_name,
            'product_details_id'   => $this->product_details_id,
            'product_details_name' => $this->product_details_name,
            'amount'               => $this->amount,
            'delivery_address'     => $this->delivery_address,
            'instruction'          => $this->instruction,
           
            'status' => $this->status,
           
        ];
    }
}
