<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CategoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'          => $this->id,
            'town'        => $this->town_name,
            'type'        => $this->type,
            'subcategory' => $this->subcategory,
            'products'    => ProductResource::collection($this->whenLoaded('products')),
        ];
    }
}
