<?php

namespace App\Http\Controllers;

use App\Models\BannerImage;
use App\Models\DeliveryFeeMaster;
use App\Models\Notification;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Product;
use App\Models\Category;
use App\Models\Courier;
use App\Models\OrderDetails;
use Database\Seeders\CourierSeeder;

class AdminController extends Controller
{

    public function login()
    {
        return view('admin.login');
    }

    public function forgot_password()
    {
        return view('admin.forgot_password');
    }

    public function create_password($email)
    {
        return view('admin.create_password', compact('email'));
    }

    public function dashboard()
    {
        return view('admin.dashboard');
    }

    public function profile()
    {
        $user = auth()->user();
        return view('admin.profile', compact('user'));
    }

    public function user_management()
    {
        $users = User::all();
        return view('admin.user_management', compact('users'));
    }

    public function delivery_fee()
    {
        $deliveries = DeliveryFeeMaster::all();
        return view('admin.delivery_fee', compact('deliveries'));
    }

    public function category()
    {
        $categories = Category::with('deliveryFeeMaster')->get();
        return view('admin.category', compact('categories'));
    }

    public function add_category()
    {
        $towns = DeliveryFeeMaster::all();
        return view('admin.add_category', compact('towns'));
    }

    public function products()
    {
        $products = Product::with(['variants', 'category'])->get();
        return view('admin.products', compact('products'));
    }
    
    public function view_product($id)
{
    $product = Product::with(['variants'])->findOrFail($id);
    $categories = Category::all();
    return view('admin.view_product', compact('product', 'categories'));
}
    
    public function add_product()
    {

        $categories = Category::all();
        return view('admin.add_product', compact('categories'));

    }
    public function banner()
    {
        $banners = BannerImage::all();
        return view('admin.banner', compact('banners'));
    }

    
    public function reset_password()
    {
        return view('admin.reset_password');
    }


    public function notification()
    {

        $notifications = Notification::all();
        return view('admin.notification', compact('notifications'));
    }

    public function recent_orders()
    {
        $recent_orders = OrderDetails::where('status','pending')->get();
        return view('admin.recent_orders',compact('recent_orders'));
    }


    public function view_orders()
    {
        $recent_orders = OrderDetails::all();
        return view('admin.view_orders',compact('recent_orders'));
    }

   
  
    public function accepted_orders()
    {
        $recent_orders = OrderDetails::where('status','accepted')->get();
        return view('admin.accepted_orders',compact('recent_orders'));
    }

    public function processing_orders()
    {
       $couriers =Courier::all();
        $recent_orders = OrderDetails::where('status','shipped')->get();
        return view('admin.processing_orders',compact('recent_orders','couriers'));
    }

    public function delivered_orders()
    {
        $recent_orders = OrderDetails::where('status','delivered')->get();
        return view('admin.delivered_orders',compact('recent_orders'));
    }

  


}
