<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\OrderDetails;
use Illuminate\Http\Request;

class OrderController extends Controller
{
    public function acceptOrder(Request $request)
    {
        $request->validate([
            'order_id' => 'required|exists:order_details,id',
        ]);
    
        $order         = OrderDetails::find($request->order_id);
        $order->status = 'accepted';
        $order->save();
        return redirect()->route('recent_orders')->with('successmessage', 'Order accepted successfully!');
      
    }
    

    public function declineOrder(Request $request)
{
    $request->validate([
        'order_id' => 'required|exists:order_details,id',
    ]);

    $order = OrderDetails::find($request->order_id);
    $order->delete(); 

    return redirect()->route('recent_orders')->with('successmessage', 'deleted successfully.');
       
}
public function shipOrder(Request $request)
{
    $request->validate([
        'order_id' => 'required|exists:order_details,id',
        
    ]);

    $order         = OrderDetails::find($request->order_id);
    $order->status = 'shipped';
    $order->save();

    return redirect()->route('accepted_orders')->with('success', 'Order shipped successfully!');
}
public function confirmDelivery(Request $request)
{
    $request->validate([
        'order_id'    => 'required|exists:order_details,id',
        'courier_id'  => 'required|exists:couriers,id',
        'tracking_id' => 'required|string|max:255',
    ]);

    $order              = OrderDetails::find($request->order_id);
    $order->status      = 'delivered';
    $order->courier     = $request->courier_id;
    $order->tracking_id = $request->tracking_id;
    $order->save();

    return redirect()->route('processing_orders')->with('success', 'Order confirmed for delivery!');
}
}



