<?php

namespace App\Http\Controllers\API;
use App\Http\Resources\BannerResource;
use App\Http\Resources\NotificationResource;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use App\Http\Resources\CategoryResource;
use App\Http\Resources\DeliveryFeeResource;
use App\Http\Resources\UserDetailsResource;
use App\Http\Resources\ProductResource;
use App\Models\BannerImage;
use App\Models\Category;
use App\Models\DeliveryFeeMaster;
use App\Models\User;
use App\Models\Notification;
use App\Models\Product;


class UserController extends Controller
{
    public function banner()
    {
        try {
            $banners = BannerImage::all();
            
            return response()->json([
                'status'  => 'success',
                'data'    => BannerResource::collection($banners),
                'message' => 'Banners fetched successfully.',
                'code'    => 200,
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Failed to fetch banners.',
                'code'    => 500,
            ], 500);
        }
    }
    
    public function notification()
    {
        try {
            $notifications = Notification::all();
            return response()->json([
                'status'  => 'success',
                'data'    => NotificationResource::collection($notifications),
                'message' => 'Notifications fetched successfully.',
                'code'    => 200,
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Failed to fetch notifications.',
                'code'    => 500,
            ], 500);
        }
    }
    public function delivery_fee()
    {
        try {
            $deliveryFees = DeliveryFeeMaster::all();
            return response()->json([
                'status'  => 'success',
                'data'    => DeliveryFeeResource::collection($deliveryFees),
                'message' => 'Delivery fees fetched successfully.',
                'code'    => 200,
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Failed to fetch delivery fees.',
                'code'    => 500,
            ], 500);
        }
    }
    public function category()
    {
        try {
            $categories = Category::all();
            return response()->json([
                'status'  => 'success',
                'data'    => CategoryResource::collection($categories),
                'message' => 'Categories fetched successfully.',
                'code'    => 200,
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Failed to fetch categories.',
                'code'    => 500,
            ], 500);
        }
    }
    
    public function category_id($id)
    {
        $validator = Validator::make(['id' => $id], [
            'id' => 'required|integer|exists:categories,id',
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status'  => 'error',
                'data'    => null,
                'message' => 'Validation failed',
                'code'    => 422,
                'errors'  => $validator->errors()
            ], 422);
        }
        $category = Category::find($id);
        if (!$category) {
            return response()->json([
                'status'  => 'error',
                'data'    => null,
                'message' => 'Category not found',
                'code'    => 404
            ], 404);
        }
        return response()->json([
            'status'  => 'success',
            'data'    => new CategoryResource($category),
            'message' => 'Category retrieved successfully',
            'code'    => 200
        ], 200);
    }
    public function products()
    {
        try {
            $products = Product::all();
            return response()->json([
                'status'  => 'success',
                'data'    => ProductResource::collection($products),
                'message' => 'Products fetched successfully.',
                'code'    => 200,
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Failed to fetch products.',
                'code'    => 500,
            ], 500);
        }
    }
    
    public function products_id($id)
    {
        $validator = Validator::make(['id' => $id], [
            'id' => 'required|integer|exists:products,id',
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status'  => 'error',
                'data'    => null,
                'message' => 'Validation failed',
                'code'    => 422,
                'errors'  => $validator->errors()
            ], 422);
        }
        $product = Product::find($id);
        if (!$product) {
            return response()->json([
                'status'  => 'error',
                'data'    => null,
                'message' => 'Product not found',
                'code'    => 404
            ], 404);
        }
        return response()->json([
            'status'  => 'success',
            'data'    => new ProductResource($product),
            'message' => 'Product retrieved successfully',
            'code'    => 200
        ], 200);
    }  
    public function user_details()
{
    try {
        $userId = 2;
        $user   = User::find($userId);
        if (!$user) {
            return response()->json([
                'status'  => 'error',
                'message' => 'User not found',
                'code'    => 404
            ], 404);
        }
        return response()->json([
            'status'  => 'success',
            'data'    => new UserDetailsResource($user),
            'message' => 'User details retrieved successfully',
            'code'    => 200
        ], 200);

    } catch (\Exception $e) {
        return response()->json([
            'status'  => 'error',
            'message' => 'Failed to retrieve user details',
            'code'    => 500,
            'error'   => $e->getMessage()
        ], 500);
    }
}
}
