<?php

namespace App\Http\Controllers\API;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\DeliveryFeeResource;
use App\Http\Resources\OrderDetailsResource;
use App\Http\Resources\CategoryResource;
use App\Http\Resources\CourierResource;
use App\Models\DeliveryFeeMaster;
use App\Models\Category;
use App\Models\Courier;

use App\Models\OrderDetails;

class CategoryController extends Controller
{
    public function delivery_fee_town($town)
    {
        try {
            $deliveryFees = DeliveryFeeMaster::where('town', $town)->get();
            if ($deliveryFees->isEmpty()) {
                return response()->json([
                    'status'  => 'success',
                    'data'    => [],
                    'message' => 'No delivery fees found for this town.',
                    'code'    => 200,
                ], 200);
            }
            return response()->json([
                'status'  => 'success',
                'data'    => DeliveryFeeResource::collection($deliveryFees),
                'message' => 'Delivery fees fetched successfully.',
                'code'    => 200,
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Failed to fetch delivery fees.',
                'code'    => 500,
            ], 500);
        }
    }
    public function delivery_fee_area($area)
    {
        try {
            $deliveryFees = DeliveryFeeMaster::where('area', $area)->get();
            if ($deliveryFees->isEmpty()) {
                return response()->json([
                    'status'  => 'success',
                    'data'    => [],
                    'message' => 'No delivery fees found for this area.',
                    'code'    => 200,
                ], 200);
            }
            return response()->json([
                'status'  => 'success',
                'data'    => DeliveryFeeResource::collection($deliveryFees),
                'message' => 'Delivery fees fetched successfully.',
                'code'    => 200,
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Failed to fetch delivery fees.',
                'code'    => 500,
            ], 500);
        }
    }
    public function order_details($user_id)
    {
        try {
            $orderDetails = OrderDetails::where('user_id', $user_id)->get();
            if ($orderDetails->isEmpty()) {
                return response()->json([
                    'status'  => 'success',
                    'data'    => [],
                    'message' => 'No order details found for this user.',
                    'code'    => 200,
                ], 200);
            }
            return response()->json([
                'status'  => 'success',
                'data'    => OrderDetailsResource::collection($orderDetails),
                'message' => 'Order details fetched successfully.',
                'code'    => 200,
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Failed to fetch order details.',
                'code'    => 500,
            ], 500);
        }
    }

    public function category_product($id)
    {
        try {
            $category = Category::with('products')->find($id);
            if (!$category) {
                return response()->json([
                    'status'  => 'error',
                    'data'    => null,
                    'message' => 'Category not found.',
                    'code'    => 404,
                ], 404);
            }
            return response()->json([
                'status'  => 'success',
                'data'    => new CategoryResource($category),
                'message' => 'Category and its products fetched successfully.',
                'code'    => 200,
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Failed to fetch category and products.',
                'code'    => 500,
            ], 500);
        }
    }
    public function accepted_orders()
    {
        try {
            $recent_orders = OrderDetails::where('status', 'accepted')->get();
            return response()->json([
                'status'  => 'success',
                'data'    => OrderDetailsResource::collection($recent_orders),
                'message' => 'Accepted orders fetched successfully.',
                'code'    => 200,
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => 'Failed to fetch accepted orders.',
                'code' => 500,
            ], 500);
        }
    }

    public function acceptedorders($id)
    {
        try {
            $query = OrderDetails::where('status', 'accepted');
            if ($id) {
                $query->where('user_id', $id);
            }
            $accepted_orders = $query->get();
            return response()->json([
                'status'  => 'success',
                'data'    => OrderDetailsResource::collection($accepted_orders),
                'message' => 'Accepted orders fetched successfully.',
                'code'    => 200,
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Failed to fetch accepted orders.',
                'code'    => 500,
            ], 500);
        }
    }

    public function delivered_orders()
       {
           try {
            $recent_orders = OrderDetails::where('status', 'delivered')->get();
            return response()->json([
                'status'  => 'success',
                'data'    => OrderDetailsResource::collection($recent_orders),
                'message' => 'Delivered orders fetched successfully.',
                'code'    => 200,
            ], 200);
           } catch (\Exception $e) {
              return response()->json([
                'status'  => 'error',
                'message' => 'Failed to fetch delivered orders.',
                'code'    => 500,
              ], 500);
        }
        }


    public function deliveredorders($id)
    {
        try {
            $query = OrderDetails::where('status', 'delivered');
            if ($id) {
                $query->where('user_id', $id);
            }
            $delivered_orders = $query->get();
            return response()->json([
                'status'  => 'success',
                'data'    => OrderDetailsResource::collection($delivered_orders),
                'message' => 'Delivered orders fetched successfully.',
                'code'    => 200,
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Failed to fetch delivered orders.',
                'code'    => 500,
            ], 500);
        }
    }

    public function shipped_orders()
    {
        try {
            $couriers      = Courier::all();
            $recent_orders = OrderDetails::where('status', 'shipped')->get();
            return response()->json([
                'status' => 'success',
                'data'   => [
                    'orders'   => OrderDetailsResource::collection($recent_orders),
                    'couriers' => CourierResource::collection($couriers),
                ],
                'message' => 'Shipped orders and couriers fetched successfully.',
                'code'    => 200,
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Failed to fetch shipped orders and couriers.',
                'code'    => 500,
            ], 500);
        }
    }
    public function shippedorders($id)
    {
        try {
            $query = OrderDetails::where('status', 'shipped');
            if ($id) {
                $query->where('user_id', $id);
            }
            $shipped_orders = $query->get();
            $couriers       = Courier::all();
            return response()->json([
                'status' => 'success',
                'data'   => [
                    'orders'   => OrderDetailsResource::collection($shipped_orders),
                    'couriers' => CourierResource::collection($couriers),
                ],
                'message' => 'Shipped orders and couriers fetched successfully.',
                'code'    => 200,
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Failed to fetch shipped orders and couriers.',
                'code'    => 500,
            ], 500);
        }
    }
}



